(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     11655,        369]*)
(*NotebookOutlinePosition[     12363,        394]*)
(*  CellTagsIndexPosition[     12319,        390]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Ejercicios", "Section"],

Cell["\<\
1 Define una funci\[OAcute]n que devuelva el primer elemento negativo de una \
lista y en caso de que la lista no tenga elementos negativos devuelva la \
expresi\[OAcute]n \"la lista no tiene elementos negativos\".\
\>", "Text"],

Cell[BoxData[{
    \(Clear[primerNegativo]\), 
    \(primerNegativo[x_List] := 
      Module[{i}, \[IndentingNewLine]i = 1; 
        \[IndentingNewLine]While[
          i \[LessEqual] Length[x] && x[\([i]\)] \[GreaterEqual] 0, 
          i = i + 1]; 
        \[IndentingNewLine]If[i > Length[x], 
          "\<la lista no tiene elementos negativos\>", x[\([i]\)]]]\)}], 
  "Input"],

Cell[BoxData[
    \(primerNegativo[{1, 2, 3, 4, 5, 6, \(-6\)}]\)], "Input"],

Cell[BoxData[{
    \(Clear[primerNegativo]\), 
    \(primerNegativo[x_List] := 
      Module[{i}, 
        \[IndentingNewLine]For[i = 1, 
          i \[LessEqual] Length[x] && x[\([i]\)] \[GreaterEqual] 0, 
          i = i + 1]; 
        \[IndentingNewLine]If[i > Length[x], 
          "\<la lista no tiene elementos negativos\>", x[\([i]\)]]]\)}], 
  "Input"],

Cell[BoxData[
    \(primerNegativo[{1, 2, 3, 4, 5, 6, \(-6\)}]\)], "Input"],

Cell[BoxData[{
    \(Clear[primerNegativo]\), 
    \(primerNegativo[x_List] := 
      \((\[IndentingNewLine]For[i = 1, 
          i \[LessEqual] Length[x] && x[\([i]\)] \[GreaterEqual] 0, 
          i = i + 1]; 
        \[IndentingNewLine]If[i > Length[x], 
          "\<la lista no tiene elementos negativos\>", x[\([i]\)]])\)\)}], 
  "Input"],

Cell[BoxData[
    \(primerNegativo[{1, 2, 3, \(-4\), 5, 6, 6}]\)], "Input"],

Cell[BoxData[{
    \(Clear[primerNegativo]\), 
    \(primerNegativo[x_] := 
      Module[{i}, i = 1; \n\t\t
        While[Length[x] > i, If[x[\([i]\)] >= 0, \(i++\), Break[]]]; \n\t\t
        If[\n\t\t\tx[\([i]\)] < 0, x[\([i]\)], 
          "\<La lista no tiene elementos negativos\>"]]\)}], "Input"],

Cell[BoxData[{
    \(Clear[primerNegativo]\), 
    \(primerNegativo[x_] := 
      Module[{i, \ control\  = \ 0}, 
        \[IndentingNewLine]For[i = 0, i < Length[x], \(i++\); 
          \[IndentingNewLine]If[x[\([i]\)] < 0, Print[x[\([i]\)]]; 
            control = \ 1; \ Break[]\[IndentingNewLine]]\[IndentingNewLine]]; 
        \[IndentingNewLine]If[\ control == \ 0, 
          Print["\<La lista no tiene elemento negativo\>"]]; \n\t\t]\)}], 
  "Input"],

Cell[BoxData[{
    \(Clear[primerNegativo]\), 
    \(primerNegativo[x_] := 
      Module[{n = 1}, 
        While[n < Length[x] && x[\([n]\)] \[GreaterEqual] 0, \(n++\)]; 
        If[x[\([n]\)] < 0, Print["\<El primer numero negativo es\>"]; 
          x[\([n]\)], Print["\<La lista no tiene elementos negativos\>"]]]
        \)}], "Input"],

Cell[BoxData[{
    \(Clear[primerNegativo]\), 
    \(primerNegativo[x_] := 
      Module[{i}\n
          For[i = 1, i <= Length[x], If[x[i]] < 0, 
            Print["\< es el primer elemento negativo de la lista \>" 
                x[\([i]\)]]; Break[]]; 
        If[i == Length[x], 
          Print["\<La lista no tiene elementos negativos\>"]]; \(i++\)]\)}], 
  "Input"],

Cell[BoxData[{
    \(Clear[primerNegativo]\), 
    \(primerNegativo[x_] := 
      Module[{i}, \n\ti = 1; \n\t\t
        While[i <= Length[x], \n\t\t\t
          If[x[\([i]\)] < 0, Break[], \(\(i++\); \)]\n\t\t]; \n\t\t\t
        If[i > Length[x], Print["\<La lista no tiene elementos negativos\>"], 
          x[\([i]\)]]\n\t]\)}], "Input"],

Cell[TextData[{
  "2 Dado un n\[UAcute]mero x>0, se puede consguir que la suma  ",
  StyleBox["1/1 + 1/2 + 1/3 + 1/4 + ...+1/n",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["  sea mayor que x ",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Times New Roman"],
  "tomando un n\[UAcute]mero ",
  StyleBox["n",
    FontFamily->"Courier"],
  " suficientemente grande. Define una funci\[OAcute]n que calcule el primer \
n\[UAcute]mero ",
  StyleBox["n",
    FontFamily->"Courier"],
  " que satisface dicha condici\[OAcute]n. Calcula ",
  StyleBox["n",
    FontFamily->"Courier"],
  " para x=10.11,13. \nSugerencia. Usa n\[UAcute]meros reales en tu funci\
\[OAcute]n para que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " no calcule simb\[OAcute]licamente."
}], "Text"],

Cell[BoxData[{
    \(Clear[sumaMayorQue]\), 
    \(\n\), 
    \(sumaMayorQue[x_?NumberQ] := 
      Module[{suma, n}, \[IndentingNewLine]suma = 0; 
        \[IndentingNewLine]n = 0; 
        \[IndentingNewLine]While[suma \[LessEqual] x, \(n++\); 
          \[IndentingNewLine]suma = suma + 1. /n]; \[IndentingNewLine]n]\)}], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sumaMayorQue[15. ]\)], "Input"],

Cell[BoxData[
    \(1835421\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "3 Define una funci\[OAcute]n que calcule el menor n\[UAcute]mero natural \
",
  StyleBox["n",
    FontFamily->"Courier"],
  " tal que ",
  Cell[BoxData[
      \(TraditionalForm\`2\^n\)]],
  " es mayor que un n\[UAcute]mero dado ",
  StyleBox["x",
    FontFamily->"Courier"],
  "."
}], "Text"],

Cell[BoxData[{
    \(Clear[potencia2MayorQue]\), "\n", 
    \(potencia2MayorQue[x_?NumberQ] := 
      Module[{producto, contador}, \[IndentingNewLine]producto = 
          1; \[IndentingNewLine]contador = 0; \[IndentingNewLine]While[
          producto \[LessEqual] 
            x, \(contador++\); \[IndentingNewLine]producto = 
            2*producto]; \[IndentingNewLine]contador]\)}], "Input"],

Cell["\<\
4 Los n\[UAcute]meros de Fibonacci son los elementos de la sucesi\[OAcute]n \
1,1,2,3,5,8,13,21,34,... cuyos primeros dos elementos son iguales a 1 y cada \
elemento posterior es la suma de los dos que le preceden. Define una funci\
\[OAcute]n que calcule el n-\[EAcute]simo n\[UAcute]mero de Fibonacci F[n]. \
Utiliza ListPlot para representar los n\[UAcute]meros de Fibonacci desde \
F[200] hasta F[250]. Repres\[EAcute]ntalos en rojo con un tama\[NTilde]o \
apropiado.\
\>", "Text"],

Cell[BoxData[{
    \(\(Clear[fib]; \)\), 
    \(\n\), 
    \(fib[n_Integer?Positive] := 
      Module[{preprefib, prefib, nuevofib}, \[IndentingNewLine]preprefib = 1; 
        \[IndentingNewLine]prefib = 1; \[IndentingNewLine]nuevofib = 2; 
        \[IndentingNewLine]Do[preprefib = prefib; 
          \[IndentingNewLine]prefib = nuevofib; 
          \[IndentingNewLine]nuevofib = preprefib + prefib, {n - 3}]; 
        \[IndentingNewLine]If[n \[LessEqual] 2, 1, nuevofib]]\)}], "Input"],

Cell[BoxData[
    \(\(ListPlot[Table[{n, fib[n]}, {n, 200, 250}], 
        PlotRange \[Rule] {fib[200], 
            fib[250]}, \[IndentingNewLine]PlotStyle \[Rule] {Hue[0], 
            PointSize[ .01]}];\)\)], "Input"],

Cell["Otra posible soluci\[OAcute]n.", "Text"],

Cell["\<\
Clear[fib];
fib[n_Integer?Positive] := Module[{preprefib,prefib,nuevofib,i},
  For[preprefib=prefib=nuevofib=i=1,
  \t\t\ti\[LessEqual]n-2, i++,
  \t\t\tpreprefib = prefib;
  \t\t\tprefib = nuevofib;
  \t\t\tnuevofib = preprefib + prefib];
  nuevofib
]\
\>", "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Inicializaci\[OAcute]n:  \"",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["preprefib",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["\", \"",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["prefib",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["\", \"",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["nuevofib",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["\",  \"",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["i",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["\" se inicializan en ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".\nTest:  deseamos iterar si \"",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["i<=(n-2)",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["\" antes de que la iteraci\[OAcute]n empiece.\nIncremento:  \"",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["i++",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["\" incrementa \"",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["i",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["\" por ",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["1",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox[".\nCuerpo:  \"",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["preprefib",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["\" se convierte en lo que era \"",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["prefib",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["\"; \"",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["prefib",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["\" se convierte en lo que era \"",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["nuevofib",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["\", y \"",
    Evaluatable->False,
    AspectRatioFixed->True],
  StyleBox["nuevofib",
    Evaluatable->False,
    AspectRatioFixed->True,
    FontFamily->"Courier"],
  StyleBox["\" se convierte en la suma de estas dos cantidades.",
    Evaluatable->False,
    AspectRatioFixed->True]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Table[fib[n], {n, 12}]\)], "Input"]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 1920}, {0, 1125}},
WindowSize->{1887, 1035},
WindowMargins->{{2, Automatic}, {Automatic, 2}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 29, 0, 83, "Section"],
Cell[1763, 53, 238, 4, 41, "Text"],
Cell[2004, 59, 381, 9, 176, "Input"],
Cell[2388, 70, 75, 1, 72, "Input"],
Cell[2466, 73, 360, 9, 150, "Input"],
Cell[2829, 84, 75, 1, 72, "Input"],
Cell[2907, 87, 344, 8, 150, "Input"],
Cell[3254, 97, 75, 1, 72, "Input"],
Cell[3332, 100, 301, 6, 176, "Input"],
Cell[3636, 108, 458, 9, 254, "Input"],
Cell[4097, 119, 339, 7, 124, "Input"],
Cell[4439, 128, 373, 9, 150, "Input"],
Cell[4815, 139, 340, 7, 254, "Input"],
Cell[5158, 148, 846, 25, 107, "Text"],
Cell[6007, 175, 335, 8, 280, "Input"],

Cell[CellGroupData[{
Cell[6367, 187, 51, 1, 72, "Input"],
Cell[6421, 190, 41, 1, 71, "Output"]
}, Open  ]],
Cell[6477, 194, 311, 12, 42, "Text"],
Cell[6791, 208, 396, 7, 280, "Input"],
Cell[7190, 217, 495, 8, 67, "Text"],
Cell[7688, 227, 487, 9, 332, "Input"],
Cell[8178, 238, 220, 4, 98, "Input"],
Cell[8401, 244, 46, 0, 41, "Text"],
Cell[8450, 246, 303, 11, 255, "Input"],
Cell[8756, 259, 2825, 104, 185, "Text",
  Evaluatable->False],
Cell[11584, 365, 55, 1, 72, "Input"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

